/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org2.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.Messages;

public class ClassNameOccurrencesFinder
extends AbstractOccurrencesFinder {
    private static final String SELF = "self";
    public static final String ID = "ClassNameOccurrencesFinder";
    private String className;
    private TypeDeclaration originalDeclarationNode;
    private Identifier nameNode;
    private Map<Identifier, String> nodeToFullName = new HashMap<Identifier, String>();

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (node instanceof Identifier) {
            ASTNode parent;
            this.nameNode = this.getIdentifierForSelf((Identifier)node);
            this.className = this.nameNode.getName();
            if (this.nameNode.getParent() instanceof NamespaceName) {
                this.nameNode = (NamespaceName)this.nameNode.getParent();
            }
            if ((parent = node.getParent()) instanceof TypeDeclaration) {
                this.originalDeclarationNode = (TypeDeclaration)parent;
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, this.className);
        this.fASTRoot.accept(this);
        if (this.nodeToFullName.containsKey(this.nameNode)) {
            String fullName = this.nodeToFullName.get(this.nameNode);
            for (Identifier nameNode : this.nodeToFullName.keySet()) {
                if (!this.nodeToFullName.get(nameNode).equals(fullName)) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(nameNode.getStart(), nameNode.getLength(), this.getOccurrenceType(nameNode), this.fDescription));
            }
        }
    }

    @Override
    public boolean visit(StaticConstantAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return false;
    }

    @Override
    public boolean visit(StaticFieldAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return false;
    }

    @Override
    public boolean visit(StaticMethodInvocation staticDispatch) {
        Expression className = staticDispatch.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return true;
    }

    @Override
    public boolean visit(ClassName className) {
        if (className.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)className.getName();
            this.dealIdentifier(identifier);
        }
        return false;
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        if (this.originalDeclarationNode == null || this.originalDeclarationNode == classDeclaration) {
            this.dealIdentifier(classDeclaration.getName());
        }
        this.checkSuper(classDeclaration.getSuperClass(), classDeclaration.interfaces());
        return true;
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        if (this.originalDeclarationNode == null || this.originalDeclarationNode == interfaceDeclaration) {
            this.dealIdentifier(interfaceDeclaration.getName());
        }
        this.checkSuper(null, interfaceDeclaration.interfaces());
        return true;
    }

    @Override
    public boolean visit(CatchClause catchStatement) {
        Expression className = catchStatement.getClassName();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return true;
    }

    @Override
    public boolean visit(FormalParameter formalParameter) {
        Expression className = formalParameter.getParameterType();
        if (className instanceof Identifier) {
            this.dealIdentifier((Identifier)className);
        }
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration) {
        ASTNode parent = methodDeclaration.getParent();
        if (parent.getType() == 6 && parent.getParent().getType() == 12) {
            ClassDeclaration classDeclaration = (ClassDeclaration)parent.getParent();
            Identifier functionName = methodDeclaration.getFunction().getFunctionName();
            if (this.checkForNameEquality(functionName)) {
                String fullName = ClassNameOccurrencesFinder.getFullName(classDeclaration.getName(), (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace);
                this.nodeToFullName.put(functionName, fullName);
            }
        }
        return true;
    }

    @Override
    public boolean visit(UseStatementPart part) {
        NamespaceName namespace = part.getName();
        if (namespace instanceof Identifier) {
            this.dealIdentifier(namespace);
        }
        return false;
    }

    private void checkSuper(Expression superClass, List<Identifier> interfaces) {
        if (superClass instanceof Identifier) {
            this.dealIdentifier((Identifier)superClass);
        }
        if (interfaces != null) {
            for (Identifier identifier : interfaces) {
                this.dealIdentifier(identifier);
            }
        }
    }

    private void dealIdentifier(Identifier identifier) {
        Identifier newIdentifier = this.getIdentifierForSelf(identifier);
        String fullName = ClassNameOccurrencesFinder.getFullName(newIdentifier, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace);
        this.nodeToFullName.put(identifier, fullName);
    }

    private Identifier getIdentifierForSelf(Identifier identifier) {
        Identifier newIdentifier = identifier;
        if (SELF.equals(identifier.getName())) {
            ClassDeclaration cd;
            ASTNode parent = identifier.getParent();
            while (parent != null && !(parent instanceof ClassDeclaration)) {
                parent = parent.getParent();
            }
            if (parent instanceof ClassDeclaration && (cd = (ClassDeclaration)parent).getName() != null) {
                newIdentifier = cd.getName();
            }
        }
        return newIdentifier;
    }

    private boolean checkForNameEquality(Identifier identifier) {
        return identifier != null && this.className != null && this.className.equals(identifier.getName());
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    @Override
    public String getElementName() {
        return this.className;
    }

    @Override
    public String getID() {
        return ID;
    }
}

